//Gemma-7B DATASET v1.0 Category: Hotel Management System ; Style: visionary
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ROOMS 10

typedef struct Room {
  int room_no;
  char status;
  char guest_name[20];
  int no_of_guests;
  double room_charge;
} Room;

Room rooms[MAX_ROOMS];

void initializeRooms() {
  for (int i = 0; i < MAX_ROOMS; i++) {
    rooms[i].room_no = i + 1;
    rooms[i].status = 'O';
    rooms[i].guest_name[0] = '\0';
    rooms[i].no_of_guests = 0;
    rooms[i].room_charge = 0.0;
  }
}

void displayRooms() {
  printf("List of Rooms:\n");
  for (int i = 0; i < MAX_ROOMS; i++) {
    printf("Room No: %d, Status: %c, Guest Name: %s, No. of Guests: %d, Room Charge: %.2lf\n", rooms[i].room_no, rooms[i].status, rooms[i].guest_name, rooms[i].no_of_guests, rooms[i].room_charge);
  }
}

void bookRoom(int room_no, char guest_name, int no_of_guests, double room_charge) {
  for (int i = 0; i < MAX_ROOMS; i++) {
    if (rooms[i].room_no == room_no && rooms[i].status == 'O') {
      rooms[i].status = 'B';
      strcpy(rooms[i].guest_name, guest_name);
      rooms[i].no_of_guests = no_of_guests;
      rooms[i].room_charge = room_charge;
      printf("Room booked successfully!\n");
      return;
    }
  }

  printf("Error: Room not available.\n");
}

int main() {
  initializeRooms();
  displayRooms();
  bookRoom(2, "John Doe", 2, 50.0);
  displayRooms();
  bookRoom(5, "Jane Doe", 1, 60.0);
  displayRooms();

  return 0;
}