//Falcon-180B DATASET v1.0 Category: Smart home automation ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SENSORS 10
#define MAX_ACTUATORS 10
#define MAX_RULES 10

typedef struct {
    char name[20];
    int value;
} Sensor;

typedef struct {
    char name[20];
    int value;
} Actuator;

typedef struct {
    char rule[50];
    int sensor1;
    int sensor2;
    int actuator;
} Rule;

Sensor sensors[MAX_SENSORS];
Actuator actuators[MAX_ACTUATORS];
Rule rules[MAX_RULES];

int numSensors = 0;
int numActuators = 0;
int numRules = 0;

void addSensor(char* name, int value) {
    strcpy(sensors[numSensors].name, name);
    sensors[numSensors].value = value;
    numSensors++;
}

void addActuator(char* name, int value) {
    strcpy(actuators[numActuators].name, name);
    actuators[numActuators].value = value;
    numActuators++;
}

void addRule(char* rule, int sensor1, int sensor2, int actuator) {
    strcpy(rules[numRules].rule, rule);
    rules[numRules].sensor1 = sensor1;
    rules[numRules].sensor2 = sensor2;
    rules[numRules].actuator = actuator;
    numRules++;
}

void evaluateRules() {
    for(int i=0; i<numRules; i++) {
        char ruleBuffer[100];
        sprintf(ruleBuffer, "If %s %s %s then %s", sensors[rules[i].sensor1].name, rules[i].rule, sensors[rules[i].sensor2].name, actuators[rules[i].actuator].name);
        printf("%s\n", ruleBuffer);
    }
}

int main() {
    addSensor("Temperature", 23);
    addSensor("Humidity", 50);
    addActuator("Fan", 0);
    addActuator("Air Conditioner", 0);

    addRule("is too high", 0, 1, 0);
    addRule("is too low", 0, 1, 1);

    evaluateRules();

    return 0;
}