//GPT-4o-mini DATASET v1.0 Category: System boot optimizer ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>

#define MAX_SERVICES 10

// Structure to hold service information
typedef struct {
    char name[50];
    int isRunning;
    int startupTime; // in seconds
} Service;

// Function to initialize services
void initializeServices(Service services[], int size) {
    strcpy(services[0].name, "Network Manager");
    services[0].isRunning = 1;
    services[0].startupTime = 5;

    strcpy(services[1].name, "Update Service");
    services[1].isRunning = 1;
    services[1].startupTime = 10;

    strcpy(services[2].name, "Database Service");
    services[2].isRunning = 1;
    services[2].startupTime = 8;

    // Initially not running services
    for (int i = 3; i < size; i++) {
        snprintf(services[i].name, sizeof(services[i].name), "Service%d", i);
        services[i].isRunning = 0;
        services[i].startupTime = (i + 1) * 2; // Multiplier for demo purpose
    }
}

// Function to display service information
void displayServices(Service services[], int size) {
    printf("\nCurrent Services and Their Status:\n");
    printf("------------------------------------------------------\n");
    printf("%-25s %-10s %-15s\n", "Service Name", "Running", "Startup Time (s)");
    printf("------------------------------------------------------\n");
    for (int i = 0; i < size; i++) {
        printf("%-25s %-10s %-15d\n", services[i].name,
               services[i].isRunning ? "Yes" : "No",
               services[i].startupTime);
    }
    printf("------------------------------------------------------\n");
}

// Function to suggest optimizations
void suggestOptimizations(Service services[], int size) {
    int totalStartupTime = 0;
    int essentialServices = 0;

    for (int i = 0; i < size; i++) {
        if (services[i].isRunning) {
            totalStartupTime += services[i].startupTime;
            essentialServices++;
        }
    }

    printf("\nOptimizations Suggestions:\n");
    printf("------------------------------------------------------\n");
    if (totalStartupTime > 30) {
        printf("Consider disabling unnecessary services to improve boot time.\n");
    }
    if (essentialServices > 5) {
        printf("You have more than 5 running services. Review if all are needed.\n");
    }
    printf("Current total boot-up time is approximately %d seconds.\n", totalStartupTime);
    printf("------------------------------------------------------\n");
}

// Function to run optimization
void optimizeBoot(Service services[], int size) {
    for (int i = 0; i < size; i++) {
        if (!services[i].isRunning && (i % 2 == 0)) { // Start every second service for example
            services[i].isRunning = 1;
            printf("Starting service: %s\n", services[i].name);
            sleep(services[i].startupTime);  // Simulating startup time
            printf("Service %s started.\n", services[i].name);
        }
    }
}

int main() {
    Service services[MAX_SERVICES];
    initializeServices(services, MAX_SERVICES);
    
    // Display initial services and their status
    displayServices(services, MAX_SERVICES);
    
    // Suggest optimizations
    suggestOptimizations(services, MAX_SERVICES);
    
    // Optimize the boot process
    printf("\nInitializing Boot Optimization...\n");
    optimizeBoot(services, MAX_SERVICES);
    
    // Final state of services after optimization
    printf("\nFinal State of Services:\n");
    displayServices(services, MAX_SERVICES);
    
    return 0;
}