//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define WIDTH 40
#define HEIGHT 20

void clearScreen() {
    printf("\033[H\033[J");
}

void drawPixel(int x, int y, char pixel) {
    if (y < 0 || y >= HEIGHT || x < 0 || x >= WIDTH) return;
    printf("\033[%d;%dH%c", y + 1, x + 1, pixel);
}

void printRainbow() {
    char* colors[] = {
        "\033[31m", // Red
        "\033[33m", // Yellow
        "\033[32m", // Green
        "\033[36m", // Cyan
        "\033[34m", // Blue
        "\033[35m", // Magenta
        "\033[0m"   // Reset
    };
    
    int colorIndex = 0;
    // Draw rainbow arcs
    for (int y = HEIGHT / 2; y > HEIGHT / 2 - 7; y--) {
        for (int x = 0; x < WIDTH; x++) {
            if (x >= (WIDTH / 2) - (7 - (HEIGHT / 2 - y))
                && x <= (WIDTH / 2) + (7 - (HEIGHT / 2 - y))) {
                printf("%s%c", colors[colorIndex], ' ');
            } else {
                printf(" ");
            }
        }
        colorIndex = (colorIndex + 1) % 6; // Loop through rainbow colors
        printf("\033[0m"); // Reset after printing row
        printf("\n");
    }
}

void drawGround() {
    // Draw the ground
    for (int y = HEIGHT / 2; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            if (x == 0 || x == WIDTH - 1) {
                printf("#"); // Draw borders
            } else {
                printf(".");
            }
        }
        printf("\n");
    }
}

int main() {
    clearScreen();
    printRainbow();
    drawGround();
    
    // Keep the window open for a few seconds
    sleep(5);
    return 0;
}