//Falcon-180B DATASET v1.0 Category: Phone Book ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NAME_LENGTH 50
#define MAX_NUMBERS_PER_PERSON 3
#define MAX_PEOPLE 100

typedef struct {
    char name[MAX_NAME_LENGTH];
    char phoneNumbers[MAX_NUMBERS_PER_PERSON][MAX_NAME_LENGTH];
    int numberOfPhoneNumbers;
} person;

void addPerson(person *phoneBook, int numberOfPeople, char *name, char *phoneNumber) {
    int i;
    for (i = 0; i < numberOfPeople; i++) {
        if (strcmp(phoneBook[i].name, name) == 0) {
            strcpy(phoneBook[i].phoneNumbers[phoneBook[i].numberOfPhoneNumbers], phoneNumber);
            phoneBook[i].numberOfPhoneNumbers++;
            return;
        }
    }
    strcpy(phoneBook[numberOfPeople].name, name);
    strcpy(phoneBook[numberOfPeople].phoneNumbers[0], phoneNumber);
    phoneBook[numberOfPeople].numberOfPhoneNumbers = 1;
    numberOfPeople++;
}

void displayPhoneBook(person *phoneBook, int numberOfPeople) {
    int i;
    for (i = 0; i < numberOfPeople; i++) {
        printf("%s:\n", phoneBook[i].name);
        int j;
        for (j = 0; j < phoneBook[i].numberOfPhoneNumbers; j++) {
            printf("\t%s\n", phoneBook[i].phoneNumbers[j]);
        }
    }
}

void searchPhoneBook(person *phoneBook, int numberOfPeople, char *name) {
    int i;
    for (i = 0; i < numberOfPeople; i++) {
        if (strcmp(phoneBook[i].name, name) == 0) {
            int j;
            for (j = 0; j < phoneBook[i].numberOfPhoneNumbers; j++) {
                printf("%s\n", phoneBook[i].phoneNumbers[j]);
            }
        }
    }
}

int main() {
    person phoneBook[MAX_PEOPLE];
    int numberOfPeople = 0;

    addPerson(phoneBook, numberOfPeople, "Alice", "123-4567");
    addPerson(phoneBook, numberOfPeople, "Bob", "987-6543");
    addPerson(phoneBook, numberOfPeople, "Charlie", "456-7890");

    displayPhoneBook(phoneBook, numberOfPeople);

    searchPhoneBook(phoneBook, numberOfPeople, "Bob");

    return 0;
}