//Falcon-180B DATASET v1.0 Category: Socket programming ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>

#define MAX 80
#define PORT 8080
#define SA struct sockaddr

void die(char *msg) {
    perror(msg);
    exit(1);
}

int main(int argc, char *argv[]) {
    int sockfd, newsockfd, portno, clilen, i, sd;
    char buffer[MAX];
    struct sockaddr_in serv_addr, cli_addr;
    socklen_t len;
    char *message = "Welcome to the server!";

    // Create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == 0)
        die("socket failed");
    printf("socket created\n");

    // Set server address
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(PORT);

    // Bind the server address to socket
    if (bind(sockfd, (SA *)&serv_addr, sizeof(serv_addr)) < 0)
        die("bind failed");
    printf("bind done\n");

    // Listen for incoming connections
    if (listen(sockfd, 5) < 0)
        die("listen");
    printf("listening...\n");

    // Accept a connection
    clilen = sizeof(cli_addr);
    newsockfd = accept(sockfd, (SA *)&cli_addr, &clilen);
    if (newsockfd < 0)
        die("accept");
    printf("connection accepted\n");

    // Send a message to the client
    send(newsockfd, message, strlen(message), 0);

    // Receive a message from the client
    bzero(buffer, MAX);
    i = recv(newsockfd, buffer, MAX, 0);
    if (i < 0)
        die("recv");
    printf("Received message: %s\n", buffer);

    // Close the connection
    close(newsockfd);
    printf("connection closed\n");

    return 0;
}