//GEMINI-pro DATASET v1.0 Category: Smart home light control ; Style: innovative
typedef struct {
    char name[20];
    int state; // 0=off, 1=on
    int brightness; // 0-100
    int color_temp; // 2700-6500
} light;

light lights[10];

void init_lights() {
    strcpy(lights[0].name, "Living Room");
    lights[0].state = 0;
    lights[0].brightness = 50;
    lights[0].color_temp = 4000;

    strcpy(lights[1].name, "Kitchen");
    lights[1].state = 0;
    lights[1].brightness = 50;
    lights[1].color_temp = 3500;

    strcpy(lights[2].name, "Bedroom");
    lights[2].state = 0;
    lights[2].brightness = 20;
    lights[2].color_temp = 2700;
}

void print_lights() {
    for (int i = 0; i < 10; i++) {
        printf("%s: ", lights[i].name);
        if (lights[i].state == 0) {
            printf("Off\n");
        } else {
            printf("On, Brightness: %d, Color Temp: %d\n", lights[i].brightness, lights[i].color_temp);
        }
    }
}

void change_light_state(char *name, int state) {
    for (int i = 0; i < 10; i++) {
        if (strcmp(lights[i].name, name) == 0) {
            lights[i].state = state;
        }
    }
}

void change_light_brightness(char *name, int brightness) {
    for (int i = 0; i < 10; i++) {
        if (strcmp(lights[i].name, name) == 0) {
            lights[i].brightness = brightness;
        }
    }
}

void change_light_color_temp(char *name, int color_temp) {
    for (int i = 0; i < 10; i++) {
        if (strcmp(lights[i].name, name) == 0) {
            lights[i].color_temp = color_temp;
        }
    }
}

int main() {
    init_lights();
    print_lights();

    change_light_state("Living Room", 1);
    change_light_brightness("Kitchen", 75);
    change_light_color_temp("Bedroom", 6500);

    print_lights();

    return 0;
}