//LLAMA2-13B DATASET v1.0 Category: String manipulation ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

// Define a struct to represent a DNA sequence
typedef struct {
    char *sequence; // the DNA sequence as a character array
    int length; // the length of the DNA sequence
} dna_seq;

// Function to calculate the GC content of a DNA sequence
void calculate_gc_content(dna_seq *seq) {
    int i, gc_count = 0;
    for (i = 0; i < seq->length; i++) {
        if (seq->sequence[i] == 'G' || seq->sequence[i] == 'C') {
            gc_count++;
        }
    }
    printf("The GC content of the DNA sequence is %d%%\n", (gc_count * 100) / seq->length);
}

// Function to reverse complement a DNA sequence
dna_seq reverse_complement(dna_seq *seq) {
    int i, j, temp;
    char rev_comp[seq->length];
    for (i = 0, j = seq->length - 1; i < seq->length; i++, j--) {
        temp = seq->sequence[i];
        seq->sequence[i] = seq->sequence[j];
        seq->sequence[j] = temp;
    }
    return *seq;
}

int main() {
    // Define a DNA sequence
    char sequence[] = "ATCGGCTGA";
    dna_seq seq = {sequence, strlen(sequence)};

    // Calculate the GC content of the DNA sequence
    calculate_gc_content(&seq);

    // Reverse complement the DNA sequence
    seq = reverse_complement(&seq);

    // Print the reversed DNA sequence
    printf("The reversed DNA sequence is: %s\n", seq.sequence);

    return 0;
}