//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    double x;
    double y;
} Point;

typedef struct {
    Point p1;
    Point p2;
} Line;

typedef struct {
    Point center;
    double radius;
} Circle;

// Function to calculate the distance between two points
double distance(Point p1, Point p2) {
    return sqrt((p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y));
}

// Function to check if a point is inside a circle
int point_in_circle(Point p, Circle c) {
    return distance(p, c.center) <= c.radius;
}

// Function to check if two lines intersect
int lines_intersect(Line l1, Line l2) {
    double x1 = l1.p1.x;
    double y1 = l1.p1.y;
    double x2 = l1.p2.x;
    double y2 = l1.p2.y;
    double x3 = l2.p1.x;
    double y3 = l2.p1.y;
    double x4 = l2.p2.x;
    double y4 = l2.p2.y;
    
    double denominator = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
    if (denominator == 0) {
        return 0; // Lines are parallel
    }
    
    double t = ((x1 - x3) * (y3 - y4) - (y1 - y3) * (x3 - x4)) / denominator;
    double u = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / denominator;
    
    return t >= 0 && t <= 1 && u >= 0 && u <= 1;
}

int main() {
    // Define a point
    Point p = {1.0, 2.0};
    
    // Define a circle
    Circle c = {{3.0, 4.0}, 2.0};
    
    // Check if the point is inside the circle
    if (point_in_circle(p, c)) {
        printf("The point is inside the circle.\n");
    } else {
        printf("The point is outside the circle.\n");
    }
    
    // Define two lines
    Line l1 = {{1.0, 1.0}, {2.0, 2.0}};
    Line l2 = {{3.0, 3.0}, {4.0, 4.0}};
    
    // Check if the lines intersect
    if (lines_intersect(l1, l2)) {
        printf("The lines intersect.\n");
    } else {
        printf("The lines do not intersect.\n");
    }
    
    return 0;
}