//LLAMA2-13B DATASET v1.0 Category: Arithmetic ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define constants and variables
#define MAX_NAME_LENGTH 25
#define MAX_GRADES 5
#define GPA_THRESHOLD 3.0

// Structure to hold student information
typedef struct {
    char name[MAX_NAME_LENGTH];
    float grade[MAX_GRADES];
} student_t;

// Function to calculate the average grade
float calculate_average(student_t *students, int num_students) {
    float total_grade = 0;
    for (int i = 0; i < num_students; i++) {
        total_grade += students[i].grade[0];
    }
    return total_grade / num_students;
}

// Function to print the report card
void print_report_card(student_t *students, int num_students) {
    for (int i = 0; i < num_students; i++) {
        printf("Student: %s\n", students[i].name);
        for (int j = 0; j < MAX_GRADES; j++) {
            printf("%.2f", students[i].grade[j]);
            if (j < MAX_GRADES - 1) {
                printf(" / ");
            }
        }
        printf("\n");
    }
}

int main() {
    // Create an array of student structures
    student_t students[5] = {
        {"Alice", {95, 85, 75, 90, 80}},
        {"Bob", {85, 75, 90, 85, 95}},
        {"Charlie", {70, 80, 90, 85, 90}},
        {"David", {80, 85, 90, 95, 90}},
        {"Eve", {90, 80, 85, 95, 90}}
    };

    // Calculate the average grade
    float average_grade = calculate_average(students, 5);

    // Print the report card
    print_report_card(students, 5);

    // Check if any students have a GPA above 3.0
    for (int i = 0; i < 5; i++) {
        if (students[i].grade[0] > GPA_THRESHOLD) {
            printf("Congratulations, %s has a GPA above 3.0!\n", students[i].name);
        }
    }

    return 0;
}