//GEMINI-pro DATASET v1.0 Category: Natural Language Date Converter ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define DAYS_IN_YEAR 365
#define DAYS_IN_MONTH 30
#define MONTHS_IN_YEAR 12

typedef struct {
    int year;
    int month;
    int day;
} Date;

int days_in_month(int month, int year) {
    if (month == 2) {
        if (year % 400 == 0 || (year % 4 == 0 && year % 100 != 0)) {
            return 29;
        } else {
            return 28;
        }
    } else if (month == 4 || month == 6 || month == 9 || month == 11) {
        return 30;
    } else {
        return 31;
    }
}

int days_in_year(int year) {
    if (year % 400 == 0 || (year % 4 == 0 && year % 100 != 0)) {
        return 366;
    } else {
        return 365;
    }
}

int days_between_dates(Date date1, Date date2) {
    int days = 0;
    days += (date2.year - date1.year) * DAYS_IN_YEAR;
    for (int month = 1; month < date1.month; month++) {
        days += days_in_month(month, date1.year);
    }
    for (int month = 1; month < date2.month; month++) {
        days += days_in_month(month, date2.year);
    }
    days += date2.day - date1.day;
    return days;
}

int main() {
    Date date1 = {2020, 1, 1};
    Date date2 = {2021, 1, 1};
    int days = days_between_dates(date1, date2);
    printf("There are %d days between %d-%d-%d and %d-%d-%d.\n", days, date1.year, date1.month, date1.day, date2.year, date2.month, date2.day);
    return 0;
}