//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>

#define MAX_PROCESS 5

typedef struct Process {
    int pid;
    int arrivalTime;
    int burstTime;
    int waitingTime;
    int turnAroundTime;
} Process;

void calculateWaitingTime(Process *processes)
{
    processes[0].waitingTime = 0;
    for (int i = 1; i < MAX_PROCESS; i++)
    {
        processes[i].waitingTime = processes[i - 1].waitingTime + processes[i - 1].burstTime;
    }
}

void calculateTurnAroundTime(Process *processes)
{
    for (int i = 0; i < MAX_PROCESS; i++)
    {
        processes[i].turnAroundTime = processes[i].waitingTime + processes[i].burstTime;
    }
}

int main()
{
    Process processes[MAX_PROCESS];

    for (int i = 0; i < MAX_PROCESS; i++)
    {
        processes[i].pid = i + 1;
        processes[i].arrivalTime = rand() % 10;
        processes[i].burstTime = rand() % 5;
    }

    calculateWaitingTime(processes);
    calculateTurnAroundTime(processes);

    printf("Process ID\tArrival Time\tBurst Time\tWaiting Time\tTurnaround Time\n");
    for (int i = 0; i < MAX_PROCESS; i++)
    {
        printf("%d\t\t%d\t\t%d\t\t%d\t\t%d\n", processes[i].pid, processes[i].arrivalTime, processes[i].burstTime, processes[i].waitingTime, processes[i].turnAroundTime);
    }

    return 0;
}