//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILE_NAME 50
#define MAX_FILE_SIZE 100
#define MAX_FILES 10

typedef struct {
    char name[MAX_FILE_NAME];
    char content[MAX_FILE_SIZE];
    int size;
} File;

int num_files = 0;
File files[MAX_FILES];

void create_file(char* name) {
    if (num_files >= MAX_FILES) {
        printf("Error: Too many files!\n");
        return;
    }
    strcpy(files[num_files].name, name);
    files[num_files].size = 0;
    num_files++;
}

void open_file(char* name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("File %s opened.\n", name);
            return;
        }
    }
    printf("Error: File not found!\n");
}

void write_file(char* name, char* content) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            strcpy(files[i].content, content);
            files[i].size = strlen(content);
            printf("File %s written.\n", name);
            return;
        }
    }
    printf("Error: File not found!\n");
}

void read_file(char* name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("File %s:\n%s\n", name, files[i].content);
            return;
        }
    }
    printf("Error: File not found!\n");
}

void delete_file(char* name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            memset(files[i].name, 0, MAX_FILE_NAME);
            memset(files[i].content, 0, MAX_FILE_SIZE);
            files[i].size = 0;
            printf("File %s deleted.\n", name);
            return;
        }
    }
    printf("Error: File not found!\n");
}

int main() {
    create_file("test.txt");
    open_file("test.txt");
    write_file("test.txt", "Hello, world!");
    read_file("test.txt");
    delete_file("test.txt");
    return 0;
}