//Falcon2-11B DATASET v1.0 Category: Checkers Game ; Style: mind-bending
#include <stdio.h>
#include <stdbool.h>

typedef struct {
    int x;
    int y;
} Coordinates;

typedef struct {
    int player;
    Coordinates position;
} Piece;

typedef struct {
    Piece* pieces[8];
    bool turn;
} Game;

void initialize_game(Game* game) {
    game->turn = true;
    for (int i = 0; i < 8; i++) {
        game->pieces[i] = NULL;
    }
}

void print_game(Game* game) {
    for (int i = 0; i < 8; i++) {
        if (game->pieces[i]!= NULL) {
            printf("%c %d,%d\n", 'X' + (game->pieces[i]->player == 1), game->pieces[i]->position.x, game->pieces[i]->position.y);
        } else {
            printf("   ");
        }
    }
    printf("\n");
}

void move_piece(Game* game, Piece* piece, Coordinates target) {
    if (game->turn) {
        if (target.x == piece->position.x && target.y == piece->position.y + 1 && (target.x == 0 || game->pieces[target.x - 1] == NULL)) {
            piece->position.x = target.x;
            piece->position.y = target.y;
            game->turn =!game->turn;
            return;
        } else if (target.x == piece->position.x && target.y == piece->position.y - 1 && (target.x == 7 || game->pieces[target.x + 1] == NULL)) {
            piece->position.x = target.x;
            piece->position.y = target.y;
            game->turn =!game->turn;
            return;
        } else if (target.x == piece->position.x && target.y == piece->position.y + 2 && (target.x == 1 || game->pieces[target.x - 1] == NULL)) {
            piece->position.x = target.x;
            piece->position.y = target.y;
            game->turn =!game->turn;
            return;
        } else if (target.x == piece->position.x && target.y == piece->position.y - 2 && (target.x == 7 || game->pieces[target.x + 1] == NULL)) {
            piece->position.x = target.x;
            piece->position.y = target.y;
            game->turn =!game->turn;
            return;
        } else if (target.x == piece->position.x && target.y == piece->position.y + 3 && (target.x == 2 || game->pieces[target.x - 1] == NULL)) {
            piece->position.x = target.x;
            piece->position.y = target.y;
            game->turn =!game->turn;
            return;
        } else if (target.x == piece->position.x && target.y == piece->position.y - 3 && (target.x == 6 || game->pieces[target.x + 1] == NULL)) {
            piece->position.x = target.x;
            piece->position.y = target.y;
            game->turn =!game->turn;
            return;
        } else if (target.x == piece->position.x && target.y == piece->position.y + 4 && (target.x == 3 || game->pieces[target.x - 1] == NULL)) {
            piece->position.x = target.x;
            piece->position.y = target.y;
            game->turn =!game->turn;
            return;
        } else if (target.x == piece->position.x && target.y == piece->position.y - 4 && (target.x == 5 || game->pieces[target.x + 1] == NULL)) {
            piece->position.x = target.x;
            piece->position.y = target.y;
            game->turn =!game->turn;
            return;
        }
    }
}

int main() {
    Game game;
    initialize_game(&game);
    print_game(&game);

    while (true) {
        printf("Enter your move (x,y): ");
        char* move = fgets(NULL, 0, stdin);
        sscanf(move, "%d,%d", &game.pieces[7]->position.x, &game.pieces[7]->position.y);
        move_piece(&game, &game.pieces[7], game.pieces[7]->position);
        print_game(&game);
    }

    return 0;
}