//Falcon-180B DATASET v1.0 Category: Traffic Flow Simulation ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_ROADS 5
#define NUM_CARS 100
#define RED_LIGHT_DURATION 5
#define GREEN_LIGHT_DURATION 10

enum road_state {
    RED_LIGHT,
    GREEN_LIGHT,
    YELLOW_LIGHT
};

struct road {
    enum road_state state;
    int num_cars;
    int green_light_duration;
    int red_light_duration;
};

void init_road(struct road *road) {
    road->state = RED_LIGHT;
    road->num_cars = 0;
    road->green_light_duration = GREEN_LIGHT_DURATION;
    road->red_light_duration = RED_LIGHT_DURATION;
}

void update_road(struct road *road) {
    if (road->state == RED_LIGHT) {
        road->state = GREEN_LIGHT;
        road->num_cars += 5;
    } else if (road->state == GREEN_LIGHT) {
        road->state = YELLOW_LIGHT;
        road->num_cars -= 5;
    } else if (road->state == YELLOW_LIGHT) {
        road->state = RED_LIGHT;
        road->num_cars -= 5;
    }
}

int main() {
    srand(time(NULL));
    struct road roads[NUM_ROADS];
    for (int i = 0; i < NUM_ROADS; i++) {
        init_road(&roads[i]);
    }

    int num_cars_passed = 0;
    while (num_cars_passed < NUM_CARS) {
        for (int i = 0; i < NUM_ROADS; i++) {
            update_road(&roads[i]);
        }
        num_cars_passed += NUM_ROADS * 5;
    }

    printf("Traffic flow simulation complete!\n");
    return 0;
}