//GEMINI-pro DATASET v1.0 Category: Networking ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main() {
    int sockfd, newsockfd, err;
    struct sockaddr_in serv_addr, cli_addr;
    char buffer[256];

    // Create a socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("ERROR opening socket");
        exit(1);
    }

    // Initialize the server address
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(PORT);

    // Bind the socket to the server address
    err = bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr));
    if (err < 0) {
        perror("ERROR on binding");
        exit(1);
    }

    // Listen for incoming connections
    err = listen(sockfd, 5);
    if (err < 0) {
        perror("ERROR on listen");
        exit(1);
    }

    // Accept an incoming connection
    newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr, (socklen_t *) &err);
    if (newsockfd < 0) {
        perror("ERROR on accept");
        exit(1);
    }

    // Read data from the client
    err = read(newsockfd, buffer, 255);
    if (err < 0) {
        perror("ERROR on read");
        exit(1);
    }

    // Process the data
    printf("Received data: %s", buffer);

    // Write data to the client
    err = write(newsockfd, "Hello, world!", 13);
    if (err < 0) {
        perror("ERROR on write");
        exit(1);
    }

    // Close the connection
    close(newsockfd);
    close(sockfd);

    return 0;
}