//Gemma-7B DATASET v1.0 Category: Password Strength Checker ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define PASSWORD_LENGTH 16

int main()
{
    char password[PASSWORD_LENGTH];
    int strength = 0;

    printf("Enter a password: ");
    fgets(password, PASSWORD_LENGTH, stdin);

    // Check for minimum length
    if (strlen(password) < PASSWORD_LENGTH)
    {
        printf("Password too short.\n");
        return 1;
    }

    // Check for uppercase letter
    if (strchr(password, 'A') || strchr(password, 'B') || strchr(password, 'C') ||
        strchr(password, 'D') || strchr(password, 'E') || strchr(password, 'F') ||
        strchr(password, 'G') || strchr(password, 'H') || strchr(password, 'I') ||
        strchr(password, 'J') || strchr(password, 'K') || strchr(password, 'L') ||
        strchr(password, 'M') || strchr(password, 'N') || strchr(password, 'O') ||
        strchr(password, 'P') || strchr(password, 'Q') || strchr(password, 'R') ||
        strchr(password, 'S') || strchr(password, 'T') || strchr(password, 'U') ||
        strchr(password, 'V') || strchr(password, 'W') || strchr(password, 'X') ||
        strchr(password, 'Y') || strchr(password, 'Z'))
    {
        strength++;
    }

    // Check for number
    if (strchr(password, '0') || strchr(password, '1') || strchr(password, '2') ||
        strchr(password, '3') || strchr(password, '4') || strchr(password, '5') ||
        strchr(password, '6') || strchr(password, '7') || strchr(password, '8') ||
        strchr(password, '9'))
    {
        strength++;
    }

    // Check for special character
    if (strchr(password, '$') || strchr(password, '%') || strchr(password, '&') ||
        strchr(password, ')') || strchr(password, '(') || strchr(password, '_') ||
        strchr(password, '+') || strchr(password, '=') || strchr(password, '`') ||
        strchr(password, '~'))
    {
        strength++;
    }

    // Calculate strength percentage
    strength = strength * 100 / PASSWORD_LENGTH;

    // Print strength
    printf("Password strength: %d%%", strength);

    return 0;
}