//GEMINI-pro DATASET v1.0 Category: Sorting ; Style: authentic
#include <stdio.h>
#include <stdlib.h>

// Define the number of elements in the array
#define NUM_ELEMENTS 10

// Define the data type of the array elements
typedef int element_type;

// Define the comparison function for qsort()
int compare(const void *a, const void *b)
{
    // Cast the arguments to the appropriate type
    element_type *aa = (element_type *)a;
    element_type *bb = (element_type *)b;

    // Compare the two elements
    if (*aa < *bb)
        return -1;
    else if (*aa > *bb)
        return 1;
    else
        return 0;
}

// Main function
int main()
{
    // Create an array of elements
    element_type array[NUM_ELEMENTS] = {10, 5, 20, 15, 7, 12, 3, 18, 9, 14};

    // Print the original array
    printf("Original array:\n");
    for (size_t i = 0; i < NUM_ELEMENTS; i++)
    {
        printf("%d ", array[i]);
    }
    printf("\n");

    // Sort the array using qsort()
    qsort(array, NUM_ELEMENTS, sizeof(element_type), compare);

    // Print the sorted array
    printf("Sorted array:\n");
    for (size_t i = 0; i < NUM_ELEMENTS; i++)
    {
        printf("%d ", array[i]);
    }
    printf("\n");

    return 0;
}