//Falcon-180B DATASET v1.0 Category: Database querying ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NAME_LENGTH 50

typedef struct {
    char name[MAX_NAME_LENGTH];
    int age;
} Person;

int compare_names(const void* a, const void* b) {
    const Person* person_a = (const Person*)a;
    const Person* person_b = (const Person*)b;

    return strcmp(person_a->name, person_b->name);
}

int compare_ages(const void* a, const void* b) {
    const Person* person_a = (const Person*)a;
    const Person* person_b = (const Person*)b;

    return person_a->age - person_b->age;
}

void print_person(const Person* person) {
    printf("Name: %s\nAge: %d\n", person->name, person->age);
}

int main() {
    Person people[] = {
        {"Alice", 25},
        {"Bob", 30},
        {"Charlie", 20},
        {"David", 35}
    };

    int num_people = sizeof(people) / sizeof(Person);

    // Sort by name
    qsort(people, num_people, sizeof(Person), compare_names);

    for (int i = 0; i < num_people; i++) {
        print_person(&people[i]);
    }

    // Sort by age
    qsort(people, num_people, sizeof(Person), compare_ages);

    for (int i = 0; i < num_people; i++) {
        print_person(&people[i]);
    }

    return 0;
}