//Gemma-7B DATASET v1.0 Category: Password Strength Checker ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define PASSWORD_LENGTH 20

void validate_password(char *password) {
  int strength = 0;
  int has_upper = 0;
  int has_lower = 0;
  int has_number = 0;
  int has_symbol = 0;

  // Check for uppercase letter
  for (int i = 0; i < PASSWORD_LENGTH; i++) {
    if (password[i] >= 'A' && password[i] <= 'Z') {
      has_upper = 1;
    }
  }

  // Check for lowercase letter
  for (int i = 0; i < PASSWORD_LENGTH; i++) {
    if (password[i] >= 'a' && password[i] <= 'z') {
      has_lower = 1;
    }
  }

  // Check for number
  for (int i = 0; i < PASSWORD_LENGTH; i++) {
    if (password[i] >= '0' && password[i] <= '9') {
      has_number = 1;
    }
  }

  // Check for symbol
  for (int i = 0; i < PASSWORD_LENGTH; i++) {
    if (password[i] >= '!' && password[i] <= '~') {
      has_symbol = 1;
    }
  }

  // Calculate strength
  strength = has_upper + has_lower + has_number + has_symbol;

  // Print strength
  switch (strength) {
    case 4:
      printf("Strength: Very Strong\n");
      break;
    case 3:
      printf("Strength: Strong\n");
      break;
    case 2:
      printf("Strength: Moderate\n");
      break;
    case 1:
      printf("Strength: Weak\n");
      break;
    default:
      printf("Strength: Invalid\n");
  }
}

int main() {
  char password[PASSWORD_LENGTH];

  // Get the password from the user
  printf("Enter a password: ");
  fgets(password, PASSWORD_LENGTH, stdin);

  // Validate the password
  validate_password(password);

  return 0;
}