//Gemma-7B DATASET v1.0 Category: Elevator Simulation ; Style: optimized
#include <stdio.h>
#include <stdlib.h>

#define MAX_FLOORS 10

typedef struct Elevator {
    int currentFloor;
    int destinationFloor;
    int passengers;
    int direction;
} Elevator;

Elevator createElevator() {
    Elevator elevator;
    elevator.currentFloor = 1;
    elevator.destinationFloor = 0;
    elevator.passengers = 0;
    elevator.direction = 0;
    return elevator;
}

void moveElevator(Elevator *elevator) {
    int targetFloor;

    if (elevator->passengers > 0) {
        targetFloor = elevator->destinationFloor;
    } else {
        targetFloor = elevator->currentFloor;
    }

    if (targetFloor != elevator->currentFloor) {
        int floorDifference = abs(targetFloor - elevator->currentFloor);

        if (elevator->direction == 0) {
            elevator->currentFloor++;
        } else if (elevator->direction == 1) {
            elevator->currentFloor--;
        }

        if (elevator->currentFloor == targetFloor) {
            elevator->passengers = 0;
            elevator->destinationFloor = 0;
        }

        printf("Elevator is moving to floor %d.\n", elevator->currentFloor);
    }
}

int main() {
    Elevator elevator = createElevator();

    // Simulate passengers getting on and off
    elevator.passengers++;
    elevator.destinationFloor = 5;

    moveElevator(&elevator);

    elevator.passengers--;
    elevator.destinationFloor = 3;

    moveElevator(&elevator);

    return 0;
}