//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_GHOULS 5

typedef struct Ghost {
    char name[20];
    int room_num;
    int activity_level;
} Ghost;

Ghost ghosts[NUM_GHOULS] = {
    {"Mr. Jones", 1, 3},
    {"Mrs. Smith", 2, 2},
    {"Mr. Brown", 3, 4},
    {"Ms. White", 4, 3},
    {"Mr. Green", 5, 2}
};

int main() {
    srand(time(NULL));

    // Choose a random ghost
    int ghost_index = rand() % NUM_GHOULS;

    // Get the ghost's name, room number, and activity level
    char ghost_name = ghosts[ghost_index].name;
    int ghost_room_num = ghosts[ghost_index].room_num;
    int ghost_activity_level = ghosts[ghost_index].activity_level;

    // Create a spooky atmosphere
    printf("The wind howls through the trees, and a cold wind blows through your hair.\n");
    printf("You hear a rustle in the hallway, and your hairs stand on end.\n");
    printf("Suddenly, a door creaks open, and you feel a presence in the room.\n");

    // Simulate ghostly activity based on the activity level
    switch (ghost_activity_level) {
        case 1:
            printf("A cold hand brushes against your skin.\n");
            break;
        case 2:
            printf("You hear footsteps coming down the hall.\n");
            break;
        case 3:
            printf("You see a ghostly figure standing in the doorway.\n");
            break;
        case 4:
            printf("The air around you becomes thick with the scent of decay.\n");
            break;
    }

    // The ghost's voice whispers your name
    printf("The ghost's voice whispers your name:\n");
    printf("%s\n", ghosts[ghost_index].name);

    // You flee from the haunted house
    printf("You sprint out of the haunted house, terrified.\n");

    return 0;
}