//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define a point in 2D space
typedef struct Point {
    double x;
    double y;
} Point;

// Define a line segment
typedef struct LineSegment {
    Point p1;
    Point p2;
} LineSegment;

// Calculate the distance between two points
double distance(Point p1, Point p2) {
    return sqrt(pow(p2.x - p1.x, 2) + pow(p2.y - p1.y, 2));
}

// Check if a point is on a line segment
int is_on_line_segment(Point p, LineSegment line) {
    double dx = line.p2.x - line.p1.x;
    double dy = line.p2.y - line.p1.y;

    double t = ((p.x - line.p1.x) * dx + (p.y - line.p1.y) * dy) / (dx * dx + dy * dy);

    return t >= 0 && t <= 1;
}

// Check if two line segments intersect
int do_line_segments_intersect(LineSegment line1, LineSegment line2) {
    // Check if the two line segments are parallel
    double dx1 = line1.p2.x - line1.p1.x;
    double dy1 = line1.p2.y - line1.p1.y;
    double dx2 = line2.p2.x - line2.p1.x;
    double dy2 = line2.p2.y - line2.p1.y;

    if (dx1 * dy2 == dx2 * dy1) {
        return 0;
    }

    // Check if the two line segments intersect
    double t1 = ((line2.p1.x - line1.p1.x) * dy2 - (line2.p1.y - line1.p1.y) * dx2) / (dx1 * dy2 - dx2 * dy1);
    double t2 = ((line2.p1.x - line1.p1.x) * dy1 - (line2.p1.y - line1.p1.y) * dx1) / (dx1 * dy2 - dx2 * dy1);

    return t1 >= 0 && t1 <= 1 && t2 >= 0 && t2 <= 1;
}

int main() {
    // Create two line segments
    LineSegment line1;
    line1.p1.x = 0;
    line1.p1.y = 0;
    line1.p2.x = 10;
    line1.p2.y = 10;

    LineSegment line2;
    line2.p1.x = 5;
    line2.p1.y = 5;
    line2.p2.x = 15;
    line2.p2.y = 15;

    // Check if the two line segments intersect
    int intersect = do_line_segments_intersect(line1, line2);

    // Print the result
    if (intersect) {
        printf("The two line segments intersect.\n");
    } else {
        printf("The two line segments do not intersect.\n");
    }

    return 0;
}