//Falcon-180B DATASET v1.0 Category: Maze Route Finder ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_ROWS 10
#define MAX_COLS 10

// Function to generate a random maze
void generateMaze(char maze[MAX_ROWS][MAX_COLS]) {
    int i, j;
    for (i = 0; i < MAX_ROWS; i++) {
        for (j = 0; j < MAX_COLS; j++) {
            maze[i][j] = rand() % 2? '.' : '#';
        }
    }

    // Set start and end points
    maze[0][0] = '.';
    maze[MAX_ROWS - 1][MAX_COLS - 1] = 'E';
}

// Function to print the maze
void printMaze(char maze[MAX_ROWS][MAX_COLS]) {
    int i, j;
    for (i = 0; i < MAX_ROWS; i++) {
        for (j = 0; j < MAX_COLS; j++) {
            printf("%c ", maze[i][j]);
        }
        printf("\n");
    }
}

// Function to find the path from start to end using DFS
void dfs(char maze[MAX_ROWS][MAX_COLS], int x, int y, int dx, int dy) {
    if (x < 0 || x >= MAX_ROWS || y < 0 || y >= MAX_COLS || maze[x][y] == '#')
        return;

    if (maze[x][y] == 'E') {
        printf("Path found:\n");
        while (x!= 0 && y!= 0) {
            if (dx == 0 && dy == -1)
                printf("U");
            else if (dx == 0 && dy == 1)
                printf("D");
            else if (dx == -1 && dy == 0)
                printf("L");
            else if (dx == 1 && dy == 0)
                printf("R");

            x += dx;
            y += dy;
        }
    } else {
        maze[x][y] = 'V';
        dfs(maze, x + dx, y + dy, dx, dy);
    }
}

int main() {
    srand(time(NULL));

    char maze[MAX_ROWS][MAX_COLS];
    generateMaze(maze);
    printMaze(maze);

    int x = 0, y = 0;
    dfs(maze, x, y, 0, -1);

    return 0;
}