//Falcon-180B DATASET v1.0 Category: Network Ping Test ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/time.h>

#define BUFFER_SIZE 1024
#define DEFAULT_PORT 80
#define DEFAULT_HOST "localhost"
#define DEFAULT_TIMEOUT 5

void usage() {
    printf("Usage:./ping [-h host] [-p port] [-t timeout]\n");
}

int main(int argc, char *argv[]) {
    char *host = DEFAULT_HOST;
    int port = DEFAULT_PORT;
    int timeout = DEFAULT_TIMEOUT;
    char buffer[BUFFER_SIZE];

    int opt;
    while ((opt = getopt(argc, argv, "h:p:t:"))!= -1) {
        switch (opt) {
        case 'h':
            host = optarg;
            break;
        case 'p':
            port = atoi(optarg);
            break;
        case 't':
            timeout = atoi(optarg);
            break;
        default:
            usage();
            return 1;
        }
    }

    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket");
        return 1;
    }

    struct sockaddr_in server_addr;
    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(port);
    if (inet_pton(AF_INET, host, &server_addr.sin_addr) <= 0) {
        fprintf(stderr, "Invalid address\n");
        close(sockfd);
        return 1;
    }

    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        if (errno == EINPROGRESS) {
            struct timeval tv;
            tv.tv_sec = timeout;
            tv.tv_usec = 0;

            fd_set writefds;
            FD_ZERO(&writefds);
            FD_SET(sockfd, &writefds);

            if (select(sockfd + 1, NULL, &writefds, NULL, &tv) <= 0) {
                fprintf(stderr, "Connection timed out\n");
                close(sockfd);
                return 1;
            }
        } else {
            perror("connect");
            close(sockfd);
            return 1;
        }
    }

    char *request = "GET / HTTP/1.1\r\nHost: %s\r\nConnection: close\r\n\r\n";
    sprintf(buffer, request, host);

    send(sockfd, buffer, strlen(buffer), 0);

    int bytes_received = 0;
    while (1) {
        int ret = recv(sockfd, buffer + bytes_received, BUFFER_SIZE - bytes_received, 0);
        if (ret <= 0) {
            break;
        }
        bytes_received += ret;
    }

    close(sockfd);

    if (bytes_received == 0) {
        fprintf(stderr, "No response received\n");
        return 1;
    }

    printf("Response:\n%s", buffer);

    return 0;
}