//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_GHOULS 10
#define MAX_POLTERGEISTS 5

typedef struct Ghost {
    char name[20];
    int type;
    int location;
} Ghost;

Ghost ghouls[MAX_GHOULS];
Ghost poltergeists[MAX_POLTERGEISTS];

void initializeGhosts() {
    for (int i = 0; i < MAX_GHOULS; i++) {
        ghouls[i].name[0] = '\0';
        ghouls[i].type = 0;
        ghouls[i].location = -1;
    }

    for (int i = 0; i < MAX_POLTERGEISTS; i++) {
        poltergeists[i].name[0] = '\0';
        poltergeists[i].type = 0;
        poltergeists[i].location = -1;
    }
}

void spawnGhost() {
    int type = rand() % 2;
    Ghost *ghost = NULL;

    if (type == 0) {
        ghost = &ghouls[0];
    } else {
        ghost = &poltergeists[0];
    }

    ghost->name[0] = 'A' + rand() % 26;
    ghost->type = type;
    ghost->location = rand() % 10;
}

void hauntHouse() {
    initializeGhosts();

    for (int i = 0; i < 10; i++) {
        spawnGhost();
    }

    printf("The haunted house is full of ghosts!\n");
}

int main() {
    hauntHouse();

    return 0;
}