//GEMINI-pro DATASET v1.0 Category: Building a IMAP Client ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define IMAP_PORT 143

int main() {
    int sockfd;
    struct sockaddr_in servaddr;

    // Create a socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    // Set up the server address
    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(IMAP_PORT);
    servaddr.sin_addr.s_addr = inet_addr("127.0.0.1");

    // Connect to the server
    if (connect(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) == -1) {
        perror("connect");
        exit(EXIT_FAILURE);
    }

    // Send a HELO command
    char buffer[1024];
    memset(buffer, 0, sizeof(buffer));
    strcpy(buffer, "HELO localhost\r\n");
    if (send(sockfd, buffer, strlen(buffer), 0) == -1) {
        perror("send");
        exit(EXIT_FAILURE);
    }

    // Receive the server response
    memset(buffer, 0, sizeof(buffer));
    if (recv(sockfd, buffer, sizeof(buffer), 0) == -1) {
        perror("recv");
        exit(EXIT_FAILURE);
    }

    // Check the server response
    if (strncmp(buffer, "+OK", 3) != 0) {
        printf("Error: Invalid server response: %s\n", buffer);
        exit(EXIT_FAILURE);
    }

    // Send an AUTHENTICATE command
    memset(buffer, 0, sizeof(buffer));
    strcpy(buffer, "AUTHENTICATE PLAIN\r\n");
    if (send(sockfd, buffer, strlen(buffer), 0) == -1) {
        perror("send");
        exit(EXIT_FAILURE);
    }

    // Send the base64-encoded credentials
    memset(buffer, 0, sizeof(buffer));
    sprintf(buffer, "%s", "dXNlcm5hbWU=\000password=");
    if (send(sockfd, buffer, strlen(buffer), 0) == -1) {
        perror("send");
        exit(EXIT_FAILURE);
    }

    // Receive the server response
    memset(buffer, 0, sizeof(buffer));
    if (recv(sockfd, buffer, sizeof(buffer), 0) == -1) {
        perror("recv");
        exit(EXIT_FAILURE);
    }

    // Check the server response
    if (strncmp(buffer, "+OK", 3) != 0) {
        printf("Error: Invalid server response: %s\n", buffer);
        exit(EXIT_FAILURE);
    }

    // Send a SELECT command
    memset(buffer, 0, sizeof(buffer));
    strcpy(buffer, "SELECT INBOX\r\n");
    if (send(sockfd, buffer, strlen(buffer), 0) == -1) {
        perror("send");
        exit(EXIT_FAILURE);
    }

    // Receive the server response
    memset(buffer, 0, sizeof(buffer));
    if (recv(sockfd, buffer, sizeof(buffer), 0) == -1) {
        perror("recv");
        exit(EXIT_FAILURE);
    }

    // Check the server response
    if (strncmp(buffer, "+OK", 3) != 0) {
        printf("Error: Invalid server response: %s\n", buffer);
        exit(EXIT_FAILURE);
    }

    // Send a FETCH command
    memset(buffer, 0, sizeof(buffer));
    strcpy(buffer, "FETCH 1:10 (RFC822)\r\n");
    if (send(sockfd, buffer, strlen(buffer), 0) == -1) {
        perror("send");
        exit(EXIT_FAILURE);
    }

    // Receive the server response
    memset(buffer, 0, sizeof(buffer));
    if (recv(sockfd, buffer, sizeof(buffer), 0) == -1) {
        perror("recv");
        exit(EXIT_FAILURE);
    }

    // Check the server response
    if (strncmp(buffer, "+OK", 3) != 0) {
        printf("Error: Invalid server response: %s\n", buffer);
        exit(EXIT_FAILURE);
    }

    // Parse the message headers
    char *start = strstr(buffer, "From:");
    if (start == NULL) {
        printf("Error: No message headers found\n");
        exit(EXIT_FAILURE);
    }

    char *end = strstr(buffer, "\r\n\r\n");
    if (end == NULL) {
        printf("Error: No message body found\n");
        exit(EXIT_FAILURE);
    }

    // Print the message headers
    int len = end - start;
    char headers[len + 1];
    strncpy(headers, start, len);
    headers[len] = '\0';
    printf("Message headers:\n%s\n", headers);

    // Print the message body
    char body[strlen(buffer) - len];
    strcpy(body, end + 4);
    printf("Message body:\n%s\n", body);

    // Send a LOGOUT command
    memset(buffer, 0, sizeof(buffer));
    strcpy(buffer, "LOGOUT\r\n");
    if (send(sockfd, buffer, strlen(buffer), 0) == -1) {
        perror("send");
        exit(EXIT_FAILURE);
    }

    // Receive the server response
    memset(buffer, 0, sizeof(buffer));
    if (recv(sockfd, buffer, sizeof(buffer), 0) == -1) {
        perror("recv");
        exit(EXIT_FAILURE);
    }

    // Check the server response
    if (strncmp(buffer, "+OK", 3) != 0) {
        printf("Error: Invalid server response: %s\n", buffer);
        exit(EXIT_FAILURE);
    }

    // Close the socket
    close(sockfd);

    return EXIT_SUCCESS;
}