//MISTRAL-7B DATASET v1.0 Category: Database simulation ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

// Define structure for employee record
typedef struct {
    int id;
    char name[50];
    float salary;
} Employee;

// Function to generate random employee ID
int generateID() {
    static int id = 1000;
    return id++;
}

// Function to generate random salary within a range
float generateSalary(float min, float max) {
    float difference = max - min;
    return min + (rand() / (RAND_MAX / difference));
}

// Function to generate random employee record
Employee generateEmployee() {
    Employee emp;
    emp.id = generateID();
    strcpy(emp.name, "Employee Name"); // Replace this with a real name generation function
    emp.salary = generateSalary(1000.0, 5000.0);
    return emp;
}

// Function to print employee record
void printEmployee(Employee emp) {
    printf("ID: %d\nName: %s\nSalary: %.2f\n", emp.id, emp.name, emp.salary);
}

// Function to create and initialize an array of employee records
void initEmployees(Employee employees[], int size) {
    for (int i = 0; i < size; i++) {
        employees[i] = generateEmployee();
    }
}

int main() {
    srand(time(NULL)); // Seed random number generator

    // Declare and initialize an array of 5 employee records
    Employee employees[5];
    int size = sizeof(employees) / sizeof(Employee);

    // Initialize the array with random employee records
    initEmployees(employees, size);

    // Print each employee record
    for (int i = 0; i < size; i++) {
        printEmployee(employees[i]);
    }

    return 0;
}