//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: surprised
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#define MAX_CARS 10
#define MAX_LANE 3

typedef struct Car {
    int x, y, direction, speed;
} Car;

Car cars[MAX_CARS];

void initializeCars() {
    for (int i = 0; i < MAX_CARS; i++) {
        cars[i].x = rand() % MAX_LANE;
        cars[i].y = rand() % MAX_LANE;
        cars[i].direction = rand() % 2;
        cars[i].speed = rand() % 5;
    }
}

void updateCars() {
    for (int i = 0; i < MAX_CARS; i++) {
        switch (cars[i].direction) {
            case 0:
                cars[i].x++;
                break;
            case 1:
                cars[i].x--;
                break;
            case 2:
                cars[i].y++;
                break;
            case 3:
                cars[i].y--;
                break;
        }

        cars[i].speed--;
        if (cars[i].speed == 0) {
            cars[i].direction = rand() % 2;
            cars[i].speed = rand() % 5;
        }
    }
}

void drawCars() {
    for (int i = 0; i < MAX_CARS; i++) {
        printf("Car %d: (x, y) = (%d, %d), direction = %d, speed = %d\n", i, cars[i].x, cars[i].y, cars[i].direction, cars[i].speed);
    }
}

int main() {
    initializeCars();
    updateCars();
    drawCars();

    return 0;
}