//GEMINI-pro DATASET v1.0 Category: TCP/IP Programming ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

// Server address and port
#define SERVER_ADDR "127.0.0.1"
#define SERVER_PORT 8080

// Buffer size for receiving and sending data
#define BUFFER_SIZE 1024

// Main function
int main() {
    // 1. Create a TCP socket
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket");
        exit(EXIT_FAILURE);
    }
    printf("TCP socket created.\n");

    // 2. Specify the server address and port
    struct sockaddr_in server_addr;
    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(SERVER_PORT);
    server_addr.sin_addr.s_addr = inet_addr(SERVER_ADDR);

    // 3. Connect to the server
    if (connect(sockfd, (struct sockaddr*)&server_addr, sizeof(server_addr)) == -1) {
        perror("connect");
        exit(EXIT_FAILURE);
    }
    printf("Connected to server.\n");

    // 4. Send data to the server
    char* message = "Hello, world!";
    if (send(sockfd, message, strlen(message), 0) == -1) {
        perror("send");
        exit(EXIT_FAILURE);
    }
    printf("Data sent to server.\n");

    // 5. Receive data from the server
    char buffer[BUFFER_SIZE];
    memset(buffer, 0, BUFFER_SIZE);
    if (recv(sockfd, buffer, BUFFER_SIZE, 0) == -1) {
        perror("recv");
        exit(EXIT_FAILURE);
    }
    printf("Data received from server: %s\n", buffer);

    // 6. Close the socket
    close(sockfd);
    return 0;
}