//GEMINI-pro DATASET v1.0 Category: Elevator Simulation ; Style: Claude Shannon
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

#define MAX_FLOORS 10
#define MAX_ELEVATORS 4

typedef struct {
  int floor;
  bool up;
} Elevator;

typedef struct {
  Elevator elevators[MAX_ELEVATORS];
  int num_elevators;
} Building;

void init_building(Building *building) {
  for (int i = 0; i < MAX_ELEVATORS; i++) {
    building->elevators[i].floor = 0;
    building->elevators[i].up = false;
  }
  building->num_elevators = 0;
}

void add_elevator(Building *building) {
  if (building->num_elevators >= MAX_ELEVATORS) {
    fprintf(stderr, "Error: cannot add more than %d elevators to the building.\n", MAX_ELEVATORS);
    return;
  }
  building->elevators[building->num_elevators].floor = 0;
  building->elevators[building->num_elevators].up = false;
  building->num_elevators++;
}

void remove_elevator(Building *building, int elevator_id) {
  if (elevator_id < 0 || elevator_id >= building->num_elevators) {
    fprintf(stderr, "Error: invalid elevator ID %d.\n", elevator_id);
    return;
  }
  for (int i = elevator_id + 1; i < building->num_elevators; i++) {
    building->elevators[i - 1] = building->elevators[i];
  }
  building->num_elevators--;
}

void move_elevator(Building *building, int elevator_id, int floor) {
  if (elevator_id < 0 || elevator_id >= building->num_elevators) {
    fprintf(stderr, "Error: invalid elevator ID %d.\n", elevator_id);
    return;
  }
  if (floor < 0 || floor >= MAX_FLOORS) {
    fprintf(stderr, "Error: invalid floor %d.\n", floor);
    return;
  }
  building->elevators[elevator_id].floor = floor;
}

void print_building(Building *building) {
  for (int i = 0; i < MAX_FLOORS; i++) {
    printf("%d: ", i);
    for (int j = 0; j < building->num_elevators; j++) {
      if (building->elevators[j].floor == i) {
        printf("%d ", j);
      }
    }
    printf("\n");
  }
}

int main(void) {
  Building building;
  init_building(&building);

  add_elevator(&building);
  add_elevator(&building);

  move_elevator(&building, 0, 3);
  move_elevator(&building, 1, 5);

  print_building(&building);

  return 0;
}