//Falcon-180B DATASET v1.0 Category: Planet Gravity Simulation ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define G 6.674e-11 // Gravitational constant

// Structure to hold information about a planet
typedef struct {
    double mass;
    double x, y, z;
    double vx, vy, vz;
} Planet;

// Function to calculate the gravitational force between two planets
void gravity(Planet p1, Planet p2) {
    double dx = p2.x - p1.x;
    double dy = p2.y - p1.y;
    double dz = p2.z - p1.z;
    double r = sqrt(dx*dx + dy*dy + dz*dz);
    double f = G * p1.mass * p2.mass / (r*r);
    p1.vx -= dx * f;
    p1.vy -= dy * f;
    p1.vz -= dz * f;
    p2.vx += dx * f;
    p2.vy += dy * f;
    p2.vz += dz * f;
}

// Function to update the position and velocity of a planet
void update(Planet p, double dt) {
    p.x += p.vx * dt;
    p.y += p.vy * dt;
    p.z += p.vz * dt;
}

// Main function
int main() {
    // Initialize the planets
    Planet earth = {6.0e24, 0, 0, 0, 0, 0};
    Planet moon = {7.3e22, 384400, 0, 0, 0, 0};
    Planet sun = {1.0e30, 0, 0, 0, 0, 0};

    // Calculate the gravitational force between the Earth and the Moon
    gravity(earth, moon);

    // Simulate the motion of the Moon around the Earth
    double dt = 86400; // One day
    for (int i = 0; i < 100; i++) {
        update(moon, dt);
        printf("Moon position: (%e, %e, %e)\n", moon.x, moon.y, moon.z);
    }

    return 0;
}