//Falcon2-11B DATASET v1.0 Category: Procedurally Generated Maze ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <stdbool.h>

// Function to create a random maze
void createMaze(int height, int width) {
    // Array to store the maze
    int maze[height][width];

    // Array to store the visited cells
    bool visited[height][width];

    // Set all cells as unvisited
    for (int i = 0; i < height; i++) {
        for (int j = 0; j < width; j++) {
            visited[i][j] = false;
        }
    }

    // Choose a random starting cell
    int startX = rand() % width;
    int startY = rand() % height;

    // Mark the starting cell as visited
    visited[startY][startX] = true;

    // Create the maze using Breadth-First Search
    int queue[100];
    int front = 0;
    int rear = 0;
    int count = 0;
    int x, y;

    while (count < height * width) {
        // If the queue is empty, break
        if (front == rear) {
            break;
        }

        // Get the cell at the front of the queue
        x = queue[front];
        y = queue[front + 1];

        // Move to the next cell
        queue[front] = queue[rear];
        queue[front + 1] = queue[rear + 1];

        // Mark the next cell as visited
        visited[y][x] = true;

        // Check if the next cell is the end of the maze
        if (x == startX && y == startY - 1) {
            // Found the end of the maze
            break;
        }

        // Add the next cell to the queue
        queue[rear] = x;
        queue[rear + 1] = y;
        rear++;
    }

    // Print the maze
    for (int i = 0; i < height; i++) {
        for (int j = 0; j < width; j++) {
            if (visited[i][j]) {
                printf(" * ");
            } else {
                printf("   ");
            }
        }
        printf("\n");
    }
}

int main() {
    // Generate a random maze of size 20x20
    int height = 20;
    int width = 20;
    createMaze(height, width);

    return 0;
}