//Falcon-180B DATASET v1.0 Category: Text Summarizer ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_SENTENCE_LENGTH 1000
#define MAX_SENTENCES 100

typedef struct sentence_t {
    char text[MAX_SENTENCE_LENGTH];
    int length;
} sentence_t;

int num_sentences = 0;
sentence_t sentences[MAX_SENTENCES];

void add_sentence(const char* input) {
    if (num_sentences >= MAX_SENTENCES) {
        printf("Error: Too many sentences\n");
        return;
    }

    int length = strlen(input);
    if (length > MAX_SENTENCE_LENGTH) {
        printf("Error: Sentence too long\n");
        return;
    }

    strcpy(sentences[num_sentences].text, input);
    sentences[num_sentences].length = length;
    num_sentences++;
}

int main() {
    add_sentence("The quick brown fox jumps over the lazy dog.");
    add_sentence("The lazy dog is not amused.");
    add_sentence("The quick brown fox doesn't care.");

    printf("Original text:\n");
    for (int i = 0; i < num_sentences; i++) {
        printf("%s\n", sentences[i].text);
    }

    printf("\nSummary:\n");
    for (int i = 0; i < num_sentences; i++) {
        int j = 0;
        while (j < sentences[i].length && isalpha(sentences[i].text[j])) {
            j++;
        }
        if (j > 0) {
            sentences[i].text[j] = '\0';
        }
        printf("%s\n", sentences[i].text);
    }

    return 0;
}