//Code Llama-13B DATASET v1.0 Category: Appointment Scheduler ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Struct to represent an appointment
struct Appointment {
    char name[100];
    int start_time;
    int end_time;
    int duration;
};

// Function to add an appointment to the schedule
void add_appointment(struct Appointment* schedule, int size, struct Appointment appointment) {
    // Check if the schedule is full
    if (size >= 100) {
        printf("Schedule is full, cannot add appointment.\n");
        return;
    }

    // Add the appointment to the schedule
    schedule[size] = appointment;
    size++;

    // Print the updated schedule
    printf("Appointment added to schedule.\n");
    for (int i = 0; i < size; i++) {
        printf("Appointment %d: %s\n", i + 1, schedule[i].name);
        printf("Start time: %d\n", schedule[i].start_time);
        printf("End time: %d\n", schedule[i].end_time);
        printf("Duration: %d\n", schedule[i].duration);
    }
}

// Function to remove an appointment from the schedule
void remove_appointment(struct Appointment* schedule, int size, int index) {
    // Check if the index is valid
    if (index < 0 || index >= size) {
        printf("Invalid index, cannot remove appointment.\n");
        return;
    }

    // Remove the appointment from the schedule
    for (int i = index; i < size - 1; i++) {
        schedule[i] = schedule[i + 1];
    }
    size--;

    // Print the updated schedule
    printf("Appointment removed from schedule.\n");
    for (int i = 0; i < size; i++) {
        printf("Appointment %d: %s\n", i + 1, schedule[i].name);
        printf("Start time: %d\n", schedule[i].start_time);
        printf("End time: %d\n", schedule[i].end_time);
        printf("Duration: %d\n", schedule[i].duration);
    }
}

// Function to update an appointment in the schedule
void update_appointment(struct Appointment* schedule, int size, int index, struct Appointment appointment) {
    // Check if the index is valid
    if (index < 0 || index >= size) {
        printf("Invalid index, cannot update appointment.\n");
        return;
    }

    // Update the appointment in the schedule
    schedule[index] = appointment;

    // Print the updated schedule
    printf("Appointment updated in schedule.\n");
    for (int i = 0; i < size; i++) {
        printf("Appointment %d: %s\n", i + 1, schedule[i].name);
        printf("Start time: %d\n", schedule[i].start_time);
        printf("End time: %d\n", schedule[i].end_time);
        printf("Duration: %d\n", schedule[i].duration);
    }
}

int main() {
    // Create an appointment schedule
    struct Appointment schedule[100];
    int size = 0;

    // Add appointments to the schedule
    struct Appointment appointment1 = {"Meeting", 10, 12, 2};
    struct Appointment appointment2 = {"Interview", 14, 16, 2};
    struct Appointment appointment3 = {"Lunch", 12, 13, 1};
    add_appointment(schedule, size, appointment1);
    add_appointment(schedule, size, appointment2);
    add_appointment(schedule, size, appointment3);

    // Remove an appointment from the schedule
    remove_appointment(schedule, size, 1);

    // Update an appointment in the schedule
    struct Appointment appointment4 = {"Training", 18, 20, 2};
    update_appointment(schedule, size, 0, appointment4);

    return 0;
}