//GPT-4o-mini DATASET v1.0 Category: Traffic Light Controller ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

typedef enum {
    RED,
    GREEN,
    YELLOW
} TrafficLightState;

void displayLight(TrafficLightState state) {
    switch (state) {
        case RED:
            printf("\n\t\t  ████████  \n");
            printf("\t\t██ RED ████  \n");
            printf("\t\t  ████████  \n");
            break;
        case GREEN:
            printf("\n\t\t  ████████  \n");
            printf("\t\t██ GREEN ████  \n");
            printf("\t\t  ████████  \n");
            break;
        case YELLOW:
            printf("\n\t\t  ████████  \n");
            printf("\t\t██ YELLOW ████  \n");
            printf("\t\t  ████████  \n");
            break;
    }
}

void honkHorn() {
    printf("Honk! Honk! A vehicle is impatient...\n");
}

void trafficLightControl() {
    TrafficLightState currentState = RED;
    int iterations = 0;

    while (iterations < 5) {
        displayLight(currentState);
        
        sleep(2); // Simulate time delay for visual effect

        switch (currentState) {
            case RED:
                currentState = GREEN;
                break;
            case GREEN:
                currentState = YELLOW;
                break;
            case YELLOW:
                currentState = RED;
                break;
        }

        // Randomly decide to honk the horn
        if (rand() % 2) {
            honkHorn();
        }

        iterations++;
    }
}

int main() {
    printf("Traffic Light Controller Simulation\n");
    printf("Press Ctrl+C to stop the simulation.\n\n");

    // Seed randomness for honking
    srand(time(NULL));

    trafficLightControl();

    printf("Traffic simulation ended. Drive safely!\n");
    return 0;
}