//GEMINI-pro DATASET v1.0 Category: Smart home automation ; Style: active
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <time.h>

#define MAX_DEVICES 10

typedef struct {
    char name[32];
    bool state;
    int type; // 0 = light, 1 = thermostat, 2 = door lock
} device;

device devices[MAX_DEVICES];
int num_devices = 0;

void add_device(char *name, bool state, int type) {
    if (num_devices >= MAX_DEVICES) {
        printf("Error: Too many devices\n");
        return;
    }

    strcpy(devices[num_devices].name, name);
    devices[num_devices].state = state;
    devices[num_devices].type = type;
    num_devices++;
}

void print_devices() {
    for (int i = 0; i < num_devices; i++) {
        printf("%s: ", devices[i].name);
        if (devices[i].type == 0) {
            printf("Light");
        } else if (devices[i].type == 1) {
            printf("Thermostat");
        } else if (devices[i].type == 2) {
            printf("Door lock");
        }
        printf(", State: %s\n", devices[i].state ? "On" : "Off");
    }
}

void turn_on_device(char *name) {
    for (int i = 0; i < num_devices; i++) {
        if (strcmp(devices[i].name, name) == 0) {
            devices[i].state = true;
            printf("%s turned on\n", name);
            return;
        }
    }

    printf("Error: Device not found\n");
}

void turn_off_device(char *name) {
    for (int i = 0; i < num_devices; i++) {
        if (strcmp(devices[i].name, name) == 0) {
            devices[i].state = false;
            printf("%s turned off\n", name);
            return;
        }
    }

    printf("Error: Device not found\n");
}

void set_thermostat(char *name, int temperature) {
    for (int i = 0; i < num_devices; i++) {
        if (strcmp(devices[i].name, name) == 0 && devices[i].type == 1) {
            printf("%s set to %d degrees\n", name, temperature);
            return;
        }
    }

    printf("Error: Thermostat not found\n");
}

void lock_door(char *name) {
    for (int i = 0; i < num_devices; i++) {
        if (strcmp(devices[i].name, name) == 0 && devices[i].type == 2) {
            devices[i].state = true;
            printf("%s locked\n", name);
            return;
        }
    }

    printf("Error: Door lock not found\n");
}

void unlock_door(char *name) {
    for (int i = 0; i < num_devices; i++) {
        if (strcmp(devices[i].name, name) == 0 && devices[i].type == 2) {
            devices[i].state = false;
            printf("%s unlocked\n", name);
            return;
        }
    }

    printf("Error: Door lock not found\n");
}

int main() {
    // Add some devices
    add_device("Living Room Light", false, 0);
    add_device("Kitchen Light", false, 0);
    add_device("Bedroom Thermostat", false, 1);
    add_device("Front Door Lock", false, 2);

    // Print the devices
    print_devices();

    // Turn on the living room light
    turn_on_device("Living Room Light");

    // Set the bedroom thermostat to 72 degrees
    set_thermostat("Bedroom Thermostat", 72);

    // Lock the front door
    lock_door("Front Door Lock");

    // Print the devices again
    print_devices();

    return 0;
}