//GPT-4o-mini DATASET v1.0 Category: Packet Capturer with pcap library ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <arpa/inet.h>
#include <netinet/ip.h>

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    // Increase the packet count
    int *count = (int *)args;
    (*count)++;

    // Get the IP header from the packet
    struct ip *ip_header = (struct ip *)(packet + 14); // Ethernet header is 14 bytes
    char source_ip[INET_ADDRSTRLEN];
    char dest_ip[INET_ADDRSTRLEN];

    // Convert IP addresses from binary to string
    inet_ntop(AF_INET, &(ip_header->ip_src), source_ip, INET_ADDRSTRLEN);
    inet_ntop(AF_INET, &(ip_header->ip_dst), dest_ip, INET_ADDRSTRLEN);

    // Print packet details
    printf("Packet #%d:\n", *count);
    printf("Timestamp: %ld.%06ld\n", header->ts.tv_sec, header->ts.tv_usec);
    printf("Packet Length: %d bytes\n", header->len);
    printf("Source IP: %s\n", source_ip);
    printf("Destination IP: %s\n", dest_ip);
    printf("-----------------------------------------------------\n");
}

int main(int argc, char *argv[]) {
    char *dev;                      // device to capture from
    char errbuf[PCAP_ERRBUF_SIZE]; // error buffer
    pcap_t *handle;                // packet capture handle
    int packet_count = 0;          // to count the number of packets

    // Find a suitable device to capture
    dev = pcap_lookupdev(errbuf);
    if (dev == NULL) {
        fprintf(stderr, "Couldn't find default device: %s\n", errbuf);
        return 1;
    }

    printf("Using device: %s\n", dev);

    // Open the device for packet capturing
    handle = pcap_open_live(dev, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", dev, errbuf);
        return 2;
    }

    // Start packet capture, passing the packet_handler function to handle packets
    pcap_loop(handle, 0, packet_handler, (u_char *)&packet_count);

    // Close the capture handle
    pcap_close(handle);
    return 0;
}