//Code Llama-13B DATASET v1.0 Category: Building a SMTP Client ; Style: cheerful
/*
 * Building a SMTP Client in C - A Cheerful Example
 *
 * This program is an example of building a simple SMTP client in C.
 * It demonstrates how to establish a connection to an SMTP server,
 * send an email, and then disconnect.
 */

#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define SERVER "smtp.example.com"
#define PORT 25

int main() {
    // Create a socket
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket() failed");
        return 1;
    }

    // Set up the server address
    struct sockaddr_in server_addr;
    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    if (inet_pton(AF_INET, SERVER, &server_addr.sin_addr) <= 0) {
        perror("inet_pton() failed");
        return 1;
    }

    // Connect to the server
    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect() failed");
        return 1;
    }

    // Send the HELO command
    char hello[] = "HELO localhost\r\n";
    send(sock, hello, strlen(hello), 0);

    // Send the MAIL FROM command
    char mail_from[] = "MAIL FROM:<sender@example.com>\r\n";
    send(sock, mail_from, strlen(mail_from), 0);

    // Send the RCPT TO command
    char rcpt_to[] = "RCPT TO:<recipient@example.com>\r\n";
    send(sock, rcpt_to, strlen(rcpt_to), 0);

    // Send the DATA command
    char data[] = "DATA\r\n";
    send(sock, data, strlen(data), 0);

    // Send the email message
    char message[] = "This is a test message\r\n";
    send(sock, message, strlen(message), 0);

    // Send the QUIT command
    char quit[] = "QUIT\r\n";
    send(sock, quit, strlen(quit), 0);

    // Close the socket
    close(sock);

    return 0;
}