//LLAMA2-13B DATASET v1.0 Category: Networking ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main() {
  // Create a socket
  int sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    perror("Socket creation failed");
    exit(EXIT_FAILURE);
  }

  // Set address and port number
  struct sockaddr_in server_addr = {
    .sin_family = AF_INET,
    .sin_port = htons(PORT),
    .sin_addr.s_addr = INADDR_ANY
  };

  // Bind the socket to the address and port
  if (bind(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
    perror("Binding failed");
    exit(EXIT_FAILURE);
  }

  // Listen for incoming connections
  if (listen(sock, 3) < 0) {
    perror("Listening failed");
    exit(EXIT_FAILURE);
  }

  printf("Listening for incoming connections...\n");

  // Accept an incoming connection
  int client_sock = accept(sock, NULL, NULL);
  if (client_sock < 0) {
    perror("Accept failed");
    exit(EXIT_FAILURE);
  }

  printf("Connection accepted from client...\n");

  // Send a welcome message to the client
  char welcome[] = "Welcome to the party, my dear client! 🎉";
  send(client_sock, welcome, strlen(welcome), 0);

  // Receive data from the client
  char buffer[1024];
  recv(client_sock, buffer, 1024, 0);

  // Print the received message
  printf("Client said: %s\n", buffer);

  // Send a response message to the client
  char response[] = "Thank you for your message! 😊";
  send(client_sock, response, strlen(response), 0);

  // Close the socket
  close(client_sock);

  return 0;
}