//MISTRAL-7B DATASET v1.0 Category: Temperature monitor ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>
#include <linux/i2c.h>

// Our temperature sensor is connected to I2C bus with address 0x27
#define I2C_ADDR 0x27

// File descriptor for I2C device
int fd;

// Function to write data to I2C device
int i2c_write(int file, char reg_addr, char *data, int len) {
    int msg_len = 1 + len;
    char write_buf[msg_len];

    write_buf[0] = (reg_addr << 1) | 0x01; // I2C write command with device address

    // Write data to the device
    if (write(file, write_buf, msg_len) != msg_len) {
        perror("Error writing to i2c device\n");
        return -1;
    }

    // Write data to the device
    if (write(file, data, len) != len) {
        perror("Error writing data to i2c device\n");
        return -1;
    }

    return 0;
}

// Function to read data from I2C device
int i2c_read(int file, char reg_addr, char *data, int len) {
    int msg_len = 1 + len;
    char read_buf[msg_len];

    // Send register address to read from
    if (i2c_write(file, reg_addr, NULL, 0) != 0) {
        perror("Error writing register address to i2c device\n");
        return -1;
    }

    // Read data from the device
    if (read(file, read_buf, len) != len) {
        perror("Error reading data from i2c device\n");
        return -1;
    }

    // Copy data to the output buffer
    memcpy(data, read_buf + 1, len);

    return 0;
}

int main() {
    // Open I2C device file
    if ((fd = open("/dev/i2c-1", O_RDWR)) < 0) {
        perror("Error opening i2c device file\n");
        exit(1);
    }

    // I2C slave address recognition
    if (ioctl(fd, I2C_SLAVE, I2C_ADDR) < 0) {
        perror("Error recognizing i2c slave address\n");
        exit(1);
    }

    // Initialize temperature sensor
    if (i2c_write(fd, 0x11, (char *)"\x01\x00", 2) != 0) {
        perror("Error initializing temperature sensor\n");
        exit(1);
    }

    int temperature = 0;

    // Read temperature from sensor
    if (i2c_read(fd, 0x00, (char *)&temperature, 2) != 0) {
        perror("Error reading temperature from sensor\n");
        exit(1);
    }

    printf("The current temperature is: %d°C\n", temperature * 0.0625);

    // Close the device file
    close(fd);

    return 0;
}