//Falcon2-11B DATASET v1.0 Category: Percolation Simulator ; Style: Cryptic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

int main() {
    srand(time(NULL));
    int width = 10;
    int height = 10;
    int board[height][width];
    int filledCells = 0;
    int openCells = 0;

    for (int i = 0; i < height; i++) {
        for (int j = 0; j < width; j++) {
            board[i][j] = rand() % 2;
        }
    }

    while (openCells > 0 && filledCells < (width * height) / 2) {
        int x = rand() % width;
        int y = rand() % height;

        if (board[y][x] == 0) {
            board[y][x] = 1;
            filledCells++;

            if (y > 0 && board[y-1][x] == 0) {
                board[y-1][x] = 1;
                filledCells++;
            }

            if (y < height - 1 && board[y+1][x] == 0) {
                board[y+1][x] = 1;
                filledCells++;
            }

            if (x > 0 && board[y][x-1] == 0) {
                board[y][x-1] = 1;
                filledCells++;
            }

            if (x < width - 1 && board[y][x+1] == 0) {
                board[y][x+1] = 1;
                filledCells++;
            }

            openCells--;
        }
    }

    if (filledCells < (width * height) / 2) {
        printf("The board has no percolation.\n");
    } else {
        printf("The board has percolation.\n");
    }

    return 0;
}