//Falcon-180B DATASET v1.0 Category: Drone Remote Control ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <string.h>

#define BAUDRATE B9600
#define DEVICE "/dev/ttyUSB0"

void setup_serial(int fd) {
    struct termios options;

    // Get the current options for the port
    tcgetattr(fd, &options);

    // Set the baud rate
    cfsetispeed(&options, BAUDRATE);
    cfsetospeed(&options, BAUDRATE);

    // Set the data format
    options.c_cflag = CS8 | CREAD | CLOCAL;

    // Set the input mode
    options.c_iflag = IGNPAR;

    // Set the output mode
    options.c_oflag = 0;

    // Set the control mode
    options.c_lflag = 0;

    // Set the local mode
    options.c_lflag &= ~(ICANON | ECHO | ECHOE | ISIG);

    // Set the new options for the port
    tcsetattr(fd, TCSANOW, &options);
}

void send_command(int fd, char* command) {
    write(fd, command, strlen(command));
    usleep(100000); // Wait for the command to be sent
}

int main() {
    int fd;
    char response[100];

    // Open the serial port
    fd = open(DEVICE, O_RDWR | O_NOCTTY | O_NDELAY);

    if (fd == -1) {
        printf("Error opening serial port\n");
        exit(1);
    }

    // Set up the serial port
    setup_serial(fd);

    // Send a test command to the drone
    send_command(fd, "AT\r");

    // Read the response from the drone
    read(fd, response, sizeof(response));
    printf("Response: %s\n", response);

    // Close the serial port
    close(fd);

    return 0;
}