//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 100
#define MAX_FILE_NAME 50
#define MAX_FILE_SIZE 1000

typedef struct {
    char name[MAX_FILE_NAME];
    int size;
    char content[MAX_FILE_SIZE];
} File;

int file_count = 0;
File files[MAX_FILES];

void create_file(char *name, int size) {
    if (file_count >= MAX_FILES) {
        printf("Error: Maximum number of files reached.\n");
        return;
    }

    strcpy(files[file_count].name, name);
    files[file_count].size = size;
    files[file_count].content[0] = '\0';
    file_count++;
}

void open_file(char *name) {
    int i;

    for (i = 0; i < file_count; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("File %s opened.\n", name);
            return;
        }
    }

    printf("Error: File not found.\n");
}

void close_file(char *name) {
    int i;

    for (i = 0; i < file_count; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("File %s closed.\n", name);
            return;
        }
    }

    printf("Error: File not found.\n");
}

void write_file(char *name, char *content) {
    int i;

    for (i = 0; i < file_count; i++) {
        if (strcmp(files[i].name, name) == 0) {
            strcpy(files[i].content, content);
            printf("Data written to file %s.\n", name);
            return;
        }
    }

    printf("Error: File not found.\n");
}

void read_file(char *name) {
    int i;

    for (i = 0; i < file_count; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("Contents of file %s:\n%s", name, files[i].content);
            return;
        }
    }

    printf("Error: File not found.\n");
}

int main() {
    create_file("test.txt", 10);
    open_file("test.txt");
    write_file("test.txt", "Hello, world!");
    read_file("test.txt");
    close_file("test.txt");

    return 0;
}