//GEMINI-pro DATASET v1.0 Category: Packet Capturer with pcap library ; Style: safe
#include <pcap.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define MAX_BYTES 2048

void got_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
  printf("Received a packet of length %d\n", header->len);

  struct sockaddr_in *source_address = (struct sockaddr_in *) packet;
  printf("Source IP: %s\n", inet_ntoa(source_address->sin_addr));

  struct sockaddr_in *destination_address = (struct sockaddr_in *) (packet + sizeof(struct sockaddr_in));
  printf("Destination IP: %s\n", inet_ntoa(destination_address->sin_addr));

  printf("Protocol: %d\n", packet[9]);

  printf("Payload:\n");
  for (int i = 14; i < header->len; i++) {
    printf("%02x ", packet[i]);
  }
  printf("\n\n");
}

int main() {
  char *device = "en0";
  char *filter = "tcp and port 80";
  int snaplen = MAX_BYTES;
  int promisc = 0;
  int timeout = 1000;
  pcap_t *handle;
  char errbuf[PCAP_ERRBUF_SIZE];

  // Open the device
  handle = pcap_open_live(device, snaplen, promisc, timeout, errbuf);
  if (handle == NULL) {
    fprintf(stderr, "Error opening device: %s\n", errbuf);
    return 1;
  }

  // Compile the filter
  struct bpf_program fp;
  if (pcap_compile(handle, &fp, filter, 0, 0) == -1) {
    fprintf(stderr, "Error compiling filter: %s\n", pcap_geterr(handle));
    return 1;
  }

  // Set the filter
  if (pcap_setfilter(handle, &fp) == -1) {
    fprintf(stderr, "Error setting filter: %s\n", pcap_geterr(handle));
    return 1;
  }

  // Start capturing packets
  pcap_loop(handle, -1, got_packet, NULL);

  // Close the device
  pcap_close(handle);

  return 0;
}