//GPT-4o-mini DATASET v1.0 Category: Greedy Algorithms ; Style: automated
#include <stdio.h>
#include <stdlib.h>

// Structure to represent an activity
struct Activity {
    int start, finish;
};

// Comparator function to sort activities by their finish time
int compare(const void* a, const void* b) {
    struct Activity* activity1 = (struct Activity*)a;
    struct Activity* activity2 = (struct Activity*)b;
    return activity1->finish - activity2->finish;
}

// Function to perform activity selection
void activitySelection(struct Activity arr[], int n) {
    // Sort activities by their finish time
    qsort(arr, n, sizeof(arr[0]), compare);

    // The first activity always gets selected
    int i = 0;
    printf("Selected activities:\n");
    printf("Activity(%d, %d)\n", arr[i].start, arr[i].finish);

    // Consider the rest of the activities
    for (int j = 1; j < n; j++) {
        // If this activity starts after or when the last selected activity finishes
        if (arr[j].start >= arr[i].finish) {
            printf("Activity(%d, %d)\n", arr[j].start, arr[j].finish);
            i = j;  // Update last selected activity to the current one
        }
    }
}

// Main function for testing the activity selection algorithm
int main() {
    // Example data: Start and finish times of 9 activities
    struct Activity arr[] = {
        {0, 6}, {5, 7}, {8, 9}, {5, 9}, {2, 4},
        {1, 2}, {3, 5}, {3, 9}, {6, 8}
    };

    int n = sizeof(arr) / sizeof(arr[0]);
    
    // Call the activity selection function
    activitySelection(arr, n);

    return 0;
}