//MISTRAL-7B DATASET v1.0 Category: Levenshtein Distance Calculator ; Style: configurable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_EDIT_OPS 10
#define STRING_LENGTH_LIMIT 100

typedef struct {
    char str[STRING_LENGTH_LIMIT];
    int len;
} String;

int min(int a, int b, int c) {
    return (a < b) ? ((a < c) ? a : c) : ((b < c) ? b : c);
}

int levenshtein_distance(String str1, String str2, int max_edit_ops) {
    int len1 = str1.len;
    int len2 = str2.len;

    if (len1 == 0)
        return len2;

    if (len2 == 0)
        return len1;

    int matrix[len1 + 1][len2 + 1];

    for (int i = 0; i <= len1; i++) {
        matrix[i][0] = i;
    }

    for (int j = 0; j <= len2; j++) {
        matrix[0][j] = j;
    }

    for (int i = 1; i <= len1; i++) {
        for (int j = 1; j <= len2; j++) {
            int cost = (str1.str[i - 1] == str2.str[j - 1]) ? 0 : 1;
            matrix[i][j] = min(matrix[i - 1][j] + 1,
                              matrix[i][j - 1] + 1,
                              matrix[i - 1][j - 1] + cost);
            if (i > 1 && j > 1 && max_edit_ops < matrix[i - 1][j - 1] + cost) {
                fprintf(stderr, "Maximum edit operations exceeded\n");
                return -1;
            }
        }
    }

    return matrix[len1][len2];
}

int main() {
    String str1 = {"hello", 5};
    String str2 = {"world", 5};

    int max_edit_ops = 3;
    int distance = levenshtein_distance(str1, str2, max_edit_ops);

    if (distance >= 0)
        printf("Levenshtein Distance: %d\n", distance);

    return 0;
}