//GEMINI-pro DATASET v1.0 Category: Personal Finance Planner ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Structure to store income and expense data
typedef struct {
    double income;
    double expenses[10];  // Assuming a maximum of 10 expense categories
    int num_expenses;
} financial_data_t;

// Calculate the total income
double calc_total_income(financial_data_t *data) {
    return data->income;
}

// Calculate the total expenses
double calc_total_expenses(financial_data_t *data) {
    double total_expenses = 0;
    for (int i = 0; i < data->num_expenses; i++) {
        total_expenses += data->expenses[i];
    }
    return total_expenses;
}

// Calculate the net income
double calc_net_income(financial_data_t *data) {
    return data->income - calc_total_expenses(data);
}

// Calculate the savings rate
double calc_savings_rate(financial_data_t *data) {
    return calc_net_income(data) / data->income * 100;
}

// Calculate the debt-to-income ratio
double calc_debt_to_income_ratio(financial_data_t *data, double debt) {
    return debt / calc_total_income(data) * 100;
}

// Print a financial summary
void print_summary(financial_data_t *data, double debt) {
    printf("Total Income: $%.2f\n", data->income);
    printf("Total Expenses: $%.2f\n", calc_total_expenses(data));
    printf("Net Income: $%.2f\n", calc_net_income(data));
    printf("Savings Rate: %.2f%%\n", calc_savings_rate(data));
    printf("Debt-to-Income Ratio: %.2f%%\n", calc_debt_to_income_ratio(data, debt));
}

int main() {
    // Initialize financial data
    financial_data_t data;
    data.income = 5000;
    data.expenses[0] = 1000;  // Rent
    data.expenses[1] = 500;   // Groceries
    data.expenses[2] = 200;   // Utilities
    data.expenses[3] = 100;   // Transportation
    data.expenses[4] = 50;    // Entertainment
    data.num_expenses = 5;

    // Calculate and print financial summary
    double debt = 10000;  // Assuming a debt of $10,000
    print_summary(&data, debt);

    return 0;
}