//MISTRAL-7B DATASET v1.0 Category: Personal Finance Planner ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CATEGORIES 10
#define MAX_TRANSACTIONS 50

typedef struct {
    char name[50];
    float amount;
    int category_index;
} Transaction;

typedef struct {
    char name[50];
    float balance;
} Category;

Category categories[MAX_CATEGORIES];
Transaction transactions[MAX_TRANSACTIONS];
int num_categories = 0, num_transactions = 0;

void add_category(char *name) {
    if (num_categories >= MAX_CATEGORIES) {
        printf("Error: Maximum number of categories reached.\n");
        return;
    }
    strcpy(categories[num_categories].name, name);
    categories[num_categories].balance = 0.0;
    num_categories++;
}

void add_transaction(char *category_name, float amount) {
    int i;
    if (num_transactions >= MAX_TRANSACTIONS) {
        printf("Error: Maximum number of transactions reached.\n");
        return;
    }
    for (i = 0; i < num_categories; i++) {
        if (strcmp(categories[i].name, category_name) == 0) {
            transactions[num_transactions].amount = amount;
            transactions[num_transactions].category_index = i;
            categories[i].balance += amount;
            num_transactions++;
            return;
        }
    }
    printf("Error: Category %s not found.\n", category_name);
}

void print_transactions() {
    int i;
    printf("\nTransactions:\n");
    for (i = 0; i < num_transactions; i++) {
        printf("%s (%s): %.2f\n", transactions[i].name, categories[transactions[i].category_index].name, transactions[i].amount);
    }
}

void print_categories() {
    int i;
    printf("\nCategories and Balances:\n");
    for (i = 0; i < num_categories; i++) {
        printf("%s: %.2f\n", categories[i].name, categories[i].balance);
    }
}

int main() {
    add_category("Food");
    add_category("Housing");
    add_category("Transportation");

    add_transaction("Food", 50.0);
    add_transaction("Food", 25.0);
    add_transaction("Housing", 1000.0);
    add_transaction("Transportation", 50.0);
    add_transaction("Food", 10.0);

    print_transactions();
    print_categories();

    return 0;
}