//GPT-4o-mini DATASET v1.0 Category: Firewall ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <netinet/ip.h>
#include <arpa/inet.h>
#include <string.h>
#include <errno.h>

#define SNAP_LEN 1518  // Define max bytes per packet to capture
#define PROMISCUOUS_MODE 0
#define TIMEOUT 1000  // Timeout in milliseconds

// Blocked IP addresses
const char *blocked_ips[] = {
    "192.168.1.10", // Example blocked IP
    "192.168.1.20"  // Another blocked IP
};
const int blocked_count = sizeof(blocked_ips) / sizeof(blocked_ips[0]);

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct ip *ip_header;
    char source_ip[INET_ADDRSTRLEN];

    // Skip Ethernet header, point to IP header
    ip_header = (struct ip *)(packet + 14);
    
    // Convert source IP to string
    inet_ntop(AF_INET, &(ip_header->ip_src), source_ip, INET_ADDRSTRLEN);
    
    // Check if the source IP is blocked
    for (int i = 0; i < blocked_count; i++) {
        if (strcmp(source_ip, blocked_ips[i]) == 0) {
            printf("Blocked packet from: %s\n", source_ip);
            return; // Ignore this packet
        }
    }

    // If not blocked, allow the packet (for demonstration just print it)
    printf("Allowed packet from: %s\n", source_ip);
}

int main(int argc, char *argv[]) {
    char *dev;  // Device to sniff on
    char errbuf[PCAP_ERRBUF_SIZE];  // Buffer for error messages
    pcap_t *handle;  // Packet capture handle

    // Find a suitable device to capture on
    dev = pcap_lookupdev(errbuf);
    if (dev == NULL) {
        fprintf(stderr, "Error finding device: %s\n", errbuf);
        return EXIT_FAILURE;
    }

    // Open the device for packet capturing
    handle = pcap_open_live(dev, SNAP_LEN, PROMISCUOUS_MODE, TIMEOUT, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Error opening device %s: %s\n", dev, errbuf);
        return EXIT_FAILURE;
    }

    printf("Starting packet capture on device %s...\n", dev);

    // Start the packet processing loop
    pcap_loop(handle, 0, packet_handler, NULL);

    // Cleanup and close the packet capture handle
    pcap_close(handle);

    return EXIT_SUCCESS;
}